function [time,co,n2o] = hiscale_importCO()


cd('E:\Google Drive\Projects\HI-SCALE SGP\Data\ARM_Data\CO');

currdir = dir;
time = [];
coraw = [];
co = [];
qcco = [];
n2o = [];

for i = 1:length(currdir)
	
	cdfcheck = ~isempty(strfind(currdir(i).name,'.cdf')) || ~isempty(strfind(currdir(i).name,'.nc'));
	if cdfcheck == 0
		continue
	end
	currfile = currdir(i).name;
	datestartidx = 16;
	year_range = datestartidx : datestartidx +3;
	month_range = datestartidx +4 : datestartidx +5;
	day_range = datestartidx +6 : datestartidx +7;
	startdate = [str2num(currfile(year_range)), str2num(currfile(month_range)), str2num(currfile(day_range)), 0, 0, 0];
	sec_time = ncread(currfile,'time');
	
	currtimemat = repmat(startdate,length(sec_time),1);
	currtimemat(:,6) = currtimemat(:,6) + sec_time;
	currtimemat = datetime(currtimemat);
	time = [time ; currtimemat];
	
	currco_raw = ncread(currfile,'co');
	coraw = [coraw; currco_raw];
	
	currco = ncread(currfile,'co_dry');
	co = [co; currco];
	
	currqcco = ncread(currfile,'qc_co_dry');
	qcco = [qcco; currqcco];
	
	currn2o = ncread(currfile,'n2o_dry');
	n2o = [n2o; currn2o];
	
end

co(qcco > 2.^13) = NaN;

n2o(n2o < 0.325) = NaN;



end